Attribute VB_Name = "Module2"
Option Explicit

Private Declare Function SetWindowsHookEx Lib "user32" Alias "SetWindowsHookExA" (ByVal idHook As Long, ByVal lpfn As Long, ByVal hmod As Long, ByVal dwThreadId As Long) As Long
Private Declare Function UnhookWindowsHookEx Lib "user32" (ByVal hHook As Long) As Long
Private Declare Function CallNextHookEx Lib "user32" (ByVal hHook As Long, ByVal ncode As Long, ByVal wParam As Long, lParam As Any) As Long


Public Const WH_CALLWNDPROC = 4
Public Const WH_CBT = 5
Public Const WH_DEBUG = 9
Public Const WH_FOREGROUNDIDLE = 11
Public Const WH_GETMESSAGE = 3
Public Const WH_HARDWARE = 8
Public Const WH_JOURNALPLAYBACK = 1
Public Const WH_JOURNALRECORD = 0
Public Const WH_KEYBOARD = 2
Public Const WH_MAX = 11
Public Const WH_MIN = (-1)
Public Const WH_MOUSE = 7
Public Const WH_MSGFILTER = (-1)
Public Const WH_SHELL = 10
Public Const WH_SYSMSGFILTER = 6

Public Const MSGF_DIALOGBOX = 0
Public Const MSGF_NEXTWINDOW = 6
Public Const MSGF_SCROLLBAR = 5
Public Const MSGF_MENU = 2
Public Const MSGF_DDEMGR = &H8001

Public Const MSGF_MAINLOOP = 8      'Not used with MsgFilter Hook
Public Const MSGF_MAX = 8           'Not used with MsgFilter Hook
Public Const MSGF_MESSAGEBOX = 1    'Not used with MsgFilter Hook
Public Const MSGF_MOVE = 3          'Not used with MsgFilter Hook
Public Const MSGF_SIZE = 4          'Not used with MsgFilter Hook
Public Const MSGF_USER = 4096       'Not used with MsgFilter Hook


Private Const HC_ACTION = 0
Private Const HC_GETNEXT = 1
Private Const HC_SKIP = 2
Private Const HC_NOREMOVE = 3
Private Const HC_NOREM = HC_NOREMOVE
Private Const HC_SYSMODALOFF = 5
Private Const HC_SYSMODALON = 4


Public Type DEBUGHOOKINFO
        hModuleHook As Long
        Reserved As Long
        lParam As Long
        wParam As Long
        code As Long
End Type

Public Type POINTAPI
        x As Long
        y As Long
End Type

Public Type MSG
    hwnd As Long
    message As Long
    wParam As Long
    lParam As Long
    time As Long
    pt As POINTAPI
End Type


Private hHook As Long
Private hDbgHook As Long

Public IsHooked As Boolean
Public IsDBGHooked As Boolean


'-----------------------------
' SET MESSAGE FILTER HOOK
'-----------------------------
Public Sub SetMessageHook()
    If IsHooked Then
        MsgBox "Don't install the hook twice or you will be unable to unhook it."
    Else
        hHook = SetWindowsHookEx(WH_MSGFILTER, AddressOf MessageProc, 0, App.ThreadID)
        IsHooked = True
    End If
End Sub

Public Sub RemoveMessageHook()
    Dim temp As Long
    temp = UnhookWindowsHookEx(hHook)
    IsHooked = False
End Sub


Public Function MessageProc(ByVal uCode As Long, ByVal wParam As Long, lParam As MSG) As Long
        
    Select Case uCode
        Case MSGF_DIALOGBOX
            Form2.Text1.Text = Form2.Text1.Text & "MSGF_DIALOGBOX    MSG:" & Hex$(lParam.message) & _
                                                  "    HWND:" & Hex$(lParam.hwnd) & _
                                                  "    WPARAM:" & Hex$(lParam.wParam) & _
                                                  "    LPARAM:" & Hex$(lParam.lParam) & vbNewLine
        Case MSGF_MENU
            Form2.Text1.Text = Form2.Text1.Text & "MSGF_MENU    MSG:" & Hex$(lParam.message) & _
                                                  "    HWND:" & Hex$(lParam.hwnd) & _
                                                  "    WPARAM:" & Hex$(lParam.wParam) & _
                                                  "    LPARAM:" & Hex$(lParam.lParam) & vbNewLine
        Case MSGF_SCROLLBAR
            Form2.Text1.Text = Form2.Text1.Text & "MSGF_SCROLLBAR    MSG:" & Hex$(lParam.message) & _
                                                  "    HWND:" & Hex$(lParam.hwnd) & _
                                                  "    WPARAM:" & Hex$(lParam.wParam) & _
                                                  "    LPARAM:" & Hex$(lParam.lParam) & vbNewLine
        Case MSGF_DDEMGR
            Form2.Text1.Text = Form2.Text1.Text & "MSGF_DDEMGR    MSG:" & Hex$(lParam.message) & _
                                                  "    HWND:" & Hex$(lParam.hwnd) & _
                                                  "    WPARAM:" & Hex$(lParam.wParam) & _
                                                  "    LPARAM:" & Hex$(lParam.lParam) & vbNewLine
        Case Else
            Form2.Text1.Text = Form2.Text1.Text & "ELSE: " & uCode
    End Select
        
    DoEvents
    MessageProc = CallNextHookEx(hHook, uCode, wParam, lParam)
End Function




'-----------------------------
' SET DEBUG FILTER HOOK
'-----------------------------
Public Sub SetDebugHook()
    If IsDBGHooked Then
        MsgBox "Don't hook it twice without unhooking, or you will be unable to unhook it."
    Else
        hDbgHook = SetWindowsHookEx(WH_DEBUG, AddressOf DebugProc, 0, App.ThreadID)
        IsDBGHooked = True
    End If
End Sub

Public Sub RemoveDebugHook()
    Dim temp As Long
    temp = UnhookWindowsHookEx(hDbgHook)
    IsDBGHooked = False
End Sub


Public Function DebugProc(ByVal uCode As Long, ByVal wParam As Long, lParam As DEBUGHOOKINFO) As Long
    Select Case wParam
        Case WH_MSGFILTER
            Form2.Text1.Text = Form2.Text1.Text & "WH_MSGFILTER    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
    End Select
        
    'To prevent the system from calling the hook, the hook procedure must return a nonzero value
    DebugProc = CallNextHookEx(hDbgHook, uCode, wParam, lParam)
End Function

